/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.enchantment.weapon;

import dev.xkmc.l2complements.content.enchantment.core.UnobtainableEnchantment;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class VoidTouchEnchantment
extends UnobtainableEnchantment {
    public VoidTouchEnchantment(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot[] slots) {
        super(rarity, category, slots);
    }

    private double getChance(AttackCache cache, ItemStack weapon, int level) {
        if (cache.getStrength() < 0.95f) {
            return 0.0;
        }
        double chance = (Double)LCConfig.COMMON.voidTouchChance.get() * (double)level;
        DamageSource source = null;
        if (cache.getLivingHurtEvent() != null) {
            source = cache.getLivingHurtEvent().getSource();
        } else if (cache.getLivingAttackEvent() != null) {
            source = cache.getLivingAttackEvent().getSource();
        }
        if (source != null) {
            if (source.m_269533_(DamageTypeTags.f_268490_)) {
                chance += ((Double)LCConfig.COMMON.voidTouchChanceBonus.get()).doubleValue();
            }
            if (source.m_269533_(DamageTypeTags.f_268437_) && source.m_269533_(DamageTypeTags.f_268413_)) {
                chance += ((Double)LCConfig.COMMON.voidTouchChanceBonus.get()).doubleValue();
            }
        }
        return chance;
    }

    private boolean allow(AttackCache cache, ItemStack weapon) {
        int level = weapon.getEnchantmentLevel((Enchantment)LCEnchantments.VOID_TOUCH.get());
        if (level <= 0) {
            return false;
        }
        double chance = this.getChance(cache, weapon, level);
        double rr = new Random(new Random(cache.getAttackTarget().f_19797_).nextLong()).nextDouble();
        return !(rr > chance);
    }

    public void postAttack(AttackCache cache, LivingAttackEvent event, ItemStack weapon) {
        if (!this.allow(cache, weapon)) {
            return;
        }
        if (event.isCanceled()) {
            event.setCanceled(false);
        }
    }

    public void initAttack(AttackCache cache, ItemStack weapon) {
        if (!this.allow(cache, weapon)) {
            return;
        }
        if (cache.getAttacker() == null) {
            return;
        }
        if (cache.getAttacker().m_21051_(Attributes.f_22281_) == null) {
            return;
        }
        double damage = cache.getAttacker().m_21133_(Attributes.f_22281_);
        if (cache.getCriticalHitEvent() != null) {
            damage *= (double)cache.getCriticalHitEvent().getDamageModifier();
        }
        float finalDamage = (float)damage;
        cache.addHurtModifier(DamageModifier.nonlinearPre((int)0, e -> Math.max(e, finalDamage)));
    }

    public void postHurt(AttackCache cache, LivingHurtEvent event, ItemStack weapon) {
        if (!this.allow(cache, weapon)) {
            return;
        }
        if (event.isCanceled()) {
            event.setCanceled(false);
        }
        event.setAmount(Math.max(event.getAmount(), cache.getPreDamage()));
    }

    public void initDamage(AttackCache cache, ItemStack weapon) {
        if (!this.allow(cache, weapon)) {
            return;
        }
        float finalDamage = cache.getPreDamage();
        cache.addDealtModifier(DamageModifier.nonlinearPre((int)5000, e -> Math.max(e, finalDamage)));
    }

    @Override
    public ChatFormatting getColor() {
        return ChatFormatting.GOLD;
    }

    public int m_44702_() {
        return 1;
    }

    public int m_6586_() {
        return 3;
    }
}

